import sass from "sass";
import fs from "fs";

const input = "../scss/style.scss";
const output = "../css/style.css";

function build() {
  const result = sass.compile(input, { style: "compressed" });
  fs.writeFileSync(output, result.css);
  console.log("✔ Sass compiled!");
}

// Watch for changes
fs.watch("../scss", { recursive: true }, () => {
  console.log("Change detected. Rebuilding...");
  build();
});

// Initial build
build();
