var substringMatcher = function (strs) {
  return function findMatches(q, cb) {
    var matches, substringRegex;
    matches = [];
    substrRegex = new RegExp(q, 'i');
    $.each(strs, function (i, str) {
      if (substrRegex.test(str)) {
        matches.push(str);
      }
    });
    cb(matches);
  };
};


var states = new Bloodhound({
  datumTokenizer: Bloodhound.tokenizers.obj.whitespace('titre'),
  queryTokenizer: Bloodhound.tokenizers.whitespace,
  // prevent duplicate removal
  identify: function(obj) { return obj.code; },

  // allow large result sets before filtering
  sufficient: 100,
  remote: {
    url: 'ajax/search-products.php?search=%QUERY', 
    wildcard: '%QUERY',
    transform: function (response) {
        console.log(response.data);
        return response.data; 
    }
  }
});

// states.initialize();

// $('.the-basics .typeahead').typeahead(
//   {
//     hint: true,
//     highlight: true,
//     minLength: 1
//   },
//   {
//     name: 'states',
//     display: 'titre',
//     source: states.ttAdapter(),
    
//     templates: {
    
//         empty: `
//             <div class="empty-message">
//                 No Record Found !
//             </div>
//         `,
    
//         suggestion: function (product) {
    
//             console.log(product);
            
//             // Defensive values to prevent Typeahead from skipping an item
//             const titre      = product.titre || "Sans titre";
//             const photo      = product.photo ? `media/products/${product.photo}` : "dist/images/default-img.png";
//             const reference  = product.reference || "N/A";
//             const url        = product.url || "#!";
//             const prixBase   = product.prix_ht_remise || "0.000";
//             const prixPromo  = product.prix_promo || "0.000";
    
//             // Build HTML
//             return `
//                 <a href="${url}" class="man-section">
//                     <div class="image-section">
//                         <img src="${photo}">
//                     </div>
//                     <div class="description-section">
//                         <h4>${titre}</h4>
//                         <p style="font-size:13px" class="m-0 ps-2">Réf: ${reference}</p>
    
//                         ${
//                             prixPromo !== "0.000"
//                             ? `<span>${prixPromo} DT</span><del>${prixBase} DT</del>`
//                             : `<span>${prixBase} DT</span>`
//                         }
//                     </div>
//                 </a>
//             `;
//         }
//     }

//   }
// );


$(".typeahead").on("input", function () {
    let query = $(this).val().trim();

    if (query.length < 1) {
        $("#searchResults").addClass("d-none");
        return;
    }

    $.ajax({
        url: "ajax/search-products.php",
        type: "GET",
        data: { search: query },
        dataType: "json",
        success: function (response) {

            console.log("API Returned:", response);

            let resultsDiv = $("#searchResults");
            resultsDiv.empty();

            if (!response.data || response.data.length === 0) {
                resultsDiv.removeClass("d-none").html(`
                    <div class="p-2 text-center text-muted">No Record Found</div>
                `);
                return;
            }

            response.data.forEach(product => {

                let titre = product.titre ?? "Sans titre";
                let img   = product.photo ? `media/products/${product.photo}` : "dist/images/default-img.png";
                let url   = product.url ?? "#!";
                let prix1 = product.prix_ht_remise;
                let prix2 = product.prix_promo;
                let reference  = product.reference || "N/A";

                let priceHTML = (prix2 !== "0.000")
                    ? `<span>${prix2} DT</span> <del>${prix1} DT</del>`
                    : `<span>${prix1} DT</span>`;
                // Build HTML
                let item = `
                    <a href="${url}" class="man-section">
                        <div class="image-section">
                            <img src="${img}">
                        </div>
                        <div class="description-section">
                            <h4>${titre}</h4>
                            <p style="font-size:13px" class="m-0 ps-2">Réf: ${reference}</p>
        
                            ${priceHTML}
                        </div>
                    </a>
                `;

                resultsDiv.append(item);
            });

            resultsDiv.removeClass("d-none");

            // Click behavior
            $(".typeahead-item").on("click", function () {
                window.location.href = $(this).data("url");
            });
        }
    });
});





