<?php

function getInstagramMediaData($url) {
    // Use cURL because Instagram blocks file_get_contents
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $url);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_USERAGENT, 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');
    $html = curl_exec($ch);
    curl_close($ch);

    if (!$html) {
        return null;
    }

    $result = [
        'type' => null,
        'thumbnail' => null,
        'thumbnails' => [],
        'video_url' => null
    ];

    // 1️⃣ Try Open Graph tags
    if (preg_match('/<meta property="og:type" content="([^"]+)"/', $html, $mType)) {
        $result['type'] = $mType[1]; // video or image
    }

    if (preg_match('/<meta property="og:image" content="([^"]+)"/', $html, $mImg)) {
        $result['thumbnail'] = $mImg[1];
    }

    if (preg_match('/<meta property="og:video" content="([^"]+)"/', $html, $mVid)) {
        $result['video_url'] = $mVid[1];
    }

    // 2️⃣ Try JSON data fallback
    if (preg_match('/window\._sharedData\s*=\s*(\{.*\});<\/script>/', $html, $matches)) {
        $json = json_decode($matches[1], true);
        $media = $json['entry_data']['PostPage'][0]['graphql']['shortcode_media'] ?? null;

        if ($media) {
            $result['type'] = $media['is_video'] ? 'video' : 'image';
            $result['thumbnail'] = $media['display_url'] ?? $result['thumbnail'];

            // Get multiple resolutions
            if (isset($media['display_resources'])) {
                foreach ($media['display_resources'] as $res) {
                    $result['thumbnails'][] = [
                        'url' => $res['src'],
                        'width' => $res['config_width'],
                        'height' => $res['config_height']
                    ];
                }
            }

            // Get video URL if available
            if (!empty($media['is_video']) && isset($media['video_url'])) {
                $result['video_url'] = $media['video_url'];
            }
        }
    }

    return $result;
}


function titrePost($id)
{
	$requete = "SELECT * FROM `post` WHERE `id` = '".$id."'";
	$resultat = executeRequete($requete);
	$data = mysqli_fetch_array($resultat);
	return afficheChamp($data['titre']);
}

function photoPost($id)
{
	$requete = "SELECT * FROM `post` WHERE `id` = '".$id."'";
	$resultat = executeRequete($requete);
	$data = mysqli_fetch_array($resultat);
	if(isset($data['photo']) && $data['photo']!=""){
	return '<img src="'.afficheChamp($data['photo']).'" border="0" width="60"  height="60" />';
	}
	else{
	return '<img src="../media/post/indispo.jpg" border="0" width="60"  height="60" />';
	}
}

function photoPostSite($id)
{
	$requete = "SELECT * FROM `post` WHERE `id` = '".$id."'";
	$resultat = executeRequete($requete);
	$data = mysqli_fetch_array($resultat);
	if(isset($data['photo']) && $data['photo']!=""){
	return afficheChamp($data['photo']);
	} else { return ''; }
}

function ApercuPost($id)
{
	$requete = "SELECT * FROM `post` WHERE `id` = '".$id."'";
	$resultat = executeRequete($requete);
	$data = mysqli_fetch_array($resultat);
	return afficheChamp($data['photo']);
}

function typePost($id)
{
	$requete = "SELECT * FROM `post` WHERE `id` = '".$id."'";
	$resultat = executeRequete($requete);
	$data = mysqli_fetch_array($resultat);
	return afficheChamp($data['type']);
}
function lienPost($id)
{
	$requete = "SELECT * FROM `post` WHERE `id` = '".$id."'";
	$resultat = executeRequete($requete);
	$data = mysqli_fetch_array($resultat);
	return afficheChamp($data['lien']);
}

function supprimerPost($id){
    $requete = 'SELECT * FROM `post` WHERE `id` = "'.$id.'"';
	$resultat = executeRequete($requete);
	$data = mysqli_fetch_array($resultat);
	$image 	= afficheChamp($data['photo']);
	if($image!="") unlink("../media/post/".nett($image));
    executeRequete("DELETE FROM `post` WHERE `id` = '".$id."'");
    return true;
}
function supprimerImagePost($id){
	$requete = "SELECT * FROM `post` WHERE `id` = '".$id."'";
	$resultat = executeRequete($requete);
	$data = mysqli_fetch_array($resultat);
	$image 	= afficheChamp($data['photo']);
	if($image!="") unlink("../media/post/".$image); 
    executeRequete("UPDATE `post` SET `photo`='' WHERE `id` = '".$id."'");
    return true;
}

?>